/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.serviceableevent;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.service.config.ClassUtils;
import com.ibm.hwmca.fw.service.config.SubclassToImplConfigData;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEvent;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventAlreadyRegisteredException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventFilter;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventNotRegisteredException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistence;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistenceException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistenceNotInitializedException;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class ServiceableEventManager {
    private static final String TRACE_MASKT = "XPASVEMT";
    private static final String TRACE_MASKF = "XPASVEMF";
    private static final String TRACE_MASKD = "XPASVEMD";
    public static final String PROPERTY_EVENT_INVENTORY = "ServiceableEventInventoryProperty";
    public static final String PROPERTY_EVENT_CHANGED = "ServiceableEventChangedProperty";
    protected List serviceableEvents = new ArrayList();
    protected PropertyChangeSupport propertyChangeSupport = null;
    protected VetoableChangeSupport vetoChangeSupport = null;
    protected Map persistence = new HashMap();
    protected Map perImpl = new HashMap();

    public ServiceableEventManager() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.vetoChangeSupport = new VetoableChangeSupport(this);
    }

    protected ServiceableEventPersistence getServiceableEventPersistence(Class theClass) throws ServiceableEventPersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ServiceableEventManager.getServiceableEventPersistence for class[" + theClass + "]");
        Class candidate = theClass;
        while (candidate != null) {
            if (this.persistence.containsKey(candidate)) {
                Trace.trace(TRACE_MASKT, "<- ServiceableEventManager.getServiceableEventPersistence found registered persistence impl[" + this.persistence.get(candidate) + "]");
                return (ServiceableEventPersistence)this.persistence.get(candidate);
            }
            candidate = candidate.getSuperclass();
        }
        Trace.trace(TRACE_MASKT, "<-! ServiceableEventManager.getServiceableEventPersistence Unable to find registered persistence impl for specified class.");
        throw new ServiceableEventPersistenceNotInitializedException("ServiceableEventManager.getServiceableEventPersistence Unable to find registered persistence impl for specified class.");
    }

    protected synchronized void addPersistenceConfigData(SubclassToImplConfigData configData) throws ServiceableEventPersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "--> ServiceableEventManager.addPersistenceConfigData for " + configData.getSubclassName());
        String subclassName = configData.getSubclassName();
        if (!this.persistence.containsKey(subclassName)) {
            ServiceableEventPersistence theImpl = null;
            String className = configData.getClassData().getClassName();
            try {
                if (!this.perImpl.containsKey(className)) {
                    Trace.trace(TRACE_MASKD, "ServiceableEventManager.addPersistenceConfigData didn't find the key for [" + className + "]");
                    theImpl = (ServiceableEventPersistence)ClassUtils.instantiate(configData.getClassData());
                } else {
                    Trace.trace(TRACE_MASKD, "ServiceableEventManager.addPersistenceConfigData the impl for [" + className + "] was already registered");
                    theImpl = (ServiceableEventPersistence)this.perImpl.get(className);
                }
            }
            catch (InvocationTargetException e) {
                Trace.trace(TRACE_MASKT, "<-! ServiceableEventManager.addPersistenceConfigData exception caught[" + e + "]");
                throw new ServiceableEventPersistenceNotInitializedException("InvocationTargetException: '" + className + "'");
            }
            catch (ClassNotFoundException e) {
                Trace.trace(TRACE_MASKT, "<-! ServiceableEventManager.addPersistenceConfigData exception caught[" + e + "]");
                throw new ServiceableEventPersistenceNotInitializedException("ClassNotFoundException: '" + className + "'");
            }
            catch (InstantiationException e) {
                Trace.trace(TRACE_MASKT, "<-! ServiceableEventManager.addPersistenceConfigData exception caught[" + e + "]");
                throw new ServiceableEventPersistenceNotInitializedException("InstantiationException: '" + className + "'");
            }
            catch (IllegalAccessException e) {
                Trace.trace(TRACE_MASKT, "<-! ServiceableEventManager.addPersistenceConfigData exception caught[" + e + "]");
                throw new ServiceableEventPersistenceNotInitializedException("IllegalAccessException: '" + className + "'");
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "<-! ServiceableEventManager.addPersistenceConfigData exception caught[" + e + "]");
                throw new ServiceableEventPersistenceNotInitializedException("HException: '" + className + "'");
            }
            try {
                Trace.trace(TRACE_MASKD, "ServiceableEventManager.addPersistenceConfigData adding to persistence map, key[" + subclassName + "], impl[" + theImpl + "]");
                this.persistence.put(Class.forName(subclassName), theImpl);
                this.perImpl.put(className, theImpl);
            }
            catch (ClassNotFoundException e) {
                Trace.trace(TRACE_MASKT, "<-! ServiceableEventManager.addPersistenceConfigData exception caught[" + e + "]");
                throw new ServiceableEventPersistenceNotInitializedException("ClassNotFoundException: '" + subclassName + "'");
            }
        }
        Trace.trace(TRACE_MASKT, "<-! ServiceableEventManager.addPersistenceConfigData Key '" + subclassName + "' already exists!");
        throw new ServiceableEventPersistenceNotInitializedException("Key '" + subclassName + "' already exists!");
        Trace.trace(TRACE_MASKD, "<-- ServiceableEventManager.addPersistenceConfigData");
    }

    protected void loadServiceableEvents() throws ServiceableEventPersistenceNotInitializedException, ServiceableEventPersistenceException {
        if (this.persistence == null) {
            throw new ServiceableEventPersistenceNotInitializedException("No persistence what so ever?");
        }
        HashSet perSet = new HashSet(this.persistence.values());
        Trace.trace(TRACE_MASKD, "ServiceableEventManager.loadServiceableEvents: perSet has " + perSet.size() + " elements");
        this.serviceableEvents.clear();
        Iterator iterator = perSet.iterator();
        while (iterator.hasNext()) {
            this.serviceableEvents.addAll(((ServiceableEventPersistence)iterator.next()).load());
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vetoChangeSupport.addVetoableChangeListener(propertyName, listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoChangeSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vetoChangeSupport.removeVetoableChangeListener(propertyName, listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoChangeSupport.removeVetoableChangeListener(listener);
    }

    public ServiceableEvent getServiceableEvent(String key) {
        Iterator iterator = this.serviceableEvents.iterator();
        while (iterator.hasNext()) {
            ServiceableEvent serviceableEvent = (ServiceableEvent)iterator.next();
            if (!serviceableEvent.getUniqueKey().equals(key)) continue;
            return serviceableEvent;
        }
        return null;
    }

    public List getAllServiceableEvents() {
        return Collections.unmodifiableList(this.serviceableEvents);
    }

    public synchronized List filter(ServiceableEventFilter filter) {
        ArrayList theReturnList = new ArrayList();
        filter.filter(theReturnList, Collections.unmodifiableList(this.serviceableEvents));
        return theReturnList;
    }

    public synchronized List filter(List filterList) {
        ListIterator filterIt = filterList.listIterator();
        List startList = Collections.unmodifiableList(this.serviceableEvents);
        ArrayList returnList = Collections.EMPTY_LIST;
        while (filterIt.hasNext() && !startList.isEmpty()) {
            returnList = new ArrayList();
            ((ServiceableEventFilter)filterIt.next()).filter(returnList, startList);
            startList = returnList;
        }
        return returnList;
    }

    public synchronized void add(ServiceableEvent serviceableEvent) throws ServiceableEventAlreadyRegisteredException, ServiceableEventPersistenceNotInitializedException, ServiceableEventPersistenceException {
        if (this.serviceableEvents.contains(serviceableEvent)) {
            throw new ServiceableEventAlreadyRegisteredException("The specified serviceableEvent appears to be registered already.");
        }
        this.serviceableEvents.add(serviceableEvent);
        this.getServiceableEventPersistence(serviceableEvent.getClass()).store(serviceableEvent);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_EVENT_INVENTORY, null, serviceableEvent);
    }

    public synchronized void remove(ServiceableEvent serviceableEvent) throws ServiceableEventNotRegisteredException, ServiceableEventPersistenceException, ServiceableEventPersistenceNotInitializedException {
        if (!this.serviceableEvents.contains(serviceableEvent)) {
            throw new ServiceableEventNotRegisteredException("The specified serviceableEvent does not exist.");
        }
        this.serviceableEvents.remove(serviceableEvent);
        this.getServiceableEventPersistence(serviceableEvent.getClass()).remove(serviceableEvent);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_EVENT_INVENTORY, serviceableEvent, null);
    }

    public synchronized void changed(ServiceableEvent serviceableEvent) throws ServiceableEventPersistenceNotInitializedException, ServiceableEventPersistenceException {
        this.getServiceableEventPersistence(serviceableEvent.getClass()).store(serviceableEvent);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_EVENT_CHANGED, serviceableEvent, null);
    }
}

